;  Russell Nelson, Clarkson University.  October 20, 1988
;  Copyright, 1988, 1989, Russell Nelson
;  Modified TERMIN.ASM to be CHKPKT.ASM return errorlevel, don't terminate
;	07/24/89 Glen Marianko, Albert Einstein College of Medicine

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

segmoffs	struc
offs		dw	?
segm            dw	?
segmoffs	ends

HT	equ	09h
CR	equ	0dh
LF	equ	0ah

code	segment byte public
	assume	cs:code, ds:code

	org	80h
phd_dioa	label	byte

	org	100h
start:
	jmp	start_1

their_isr	dd	?
packet_int_no	db	0,0
		db	0,0		; filler for print_number
packet_int_end  db	0,0
signature	db	'PKT DRVR',0
signature_len	equ	$-signature
got_int		db	0
no_signature_msg	db	"Packet driver not found.",CR,LF,'$'
signature_msg	db	"Packet driver found at ",'$'
no_signatures_msg	db	"No packet driver found in specified range.",CR,LF,'$'
usage_msg	db	"usage: chkpkt <packet_int_no> (packet_int_no_end)",CR,LF,'$'

usage_error:
	mov	dx,offset usage_msg
error:
	mov	ah,9
	int	21h
err_quit:
	mov	al,1
        mov     ah,04ch                 ; exit with errorlevel 1
        int     21h

start_1:
	mov	si,offset phd_dioa+1
	call	skip_blanks
	cmp	al,CR			;end of line?
	je	usage_error

	mov	di,offset packet_int_no
	call	get_number
	cmp	packet_int_no+1,0
	jne	usage_error

	mov	di,offset packet_int_end
	call	get_number
	cmp	packet_int_end+1,0
	jne	usage_error
	mov	di,si
	call	skip_blanks
	cmp	al,CR			;end of line?
	jne	usage_error

	cmp	packet_int_end,0
	jne	chk_range		; second arg specified

	call	chk_int
	jne	no_signature_err
	call	pkt_found
done:
	mov	al,0
	mov	ah,04ch
	int	21h			; exit with errorlevel 0

no_signature_err:
	mov	dx,offset no_signature_msg
	jmp	error

chk_range:
	mov	al,packet_int_end
	sub	al,packet_int_no
	jc	usage_error

chk_loop:
	call	chk_int
	jne	chk_none
	call	pkt_found
	inc	got_int			; flag we got one
chk_none:
	mov	al,packet_int_no
	cmp	packet_int_end,al
	jz	no_signatures_chk
	inc	packet_int_no		; increment
	jmp	chk_loop

no_signatures_chk:
	cmp	got_int,0
	jnz	done

no_signatures:
	mov	dx,offset no_signatures_msg
	jmp	error

	public	chk_int
chk_int:
	mov	ah,35h			;get their packet interrupt.
	mov	al,packet_int_no
	int	21h
	mov	their_isr.offs,bx
	mov	their_isr.segm,es
	lea	di,3[bx]
	mov	si,offset signature
	mov	cx,signature_len
	repe	cmpsb
	ret

	public	pkt_found
pkt_found:
	mov	dx,offset signature_msg
	mov	di,offset packet_int_no
	jmp	print_number

	public	get_number
get_number:
	mov	bp,10			;we default to 10.
	jmp	short get_number_0

	public	get_hex
get_hex:
	mov	bp,16
;get a hex number from [si], skipping leading blanks.
;return cy if there are no digits at all.
;return nc, bx:cx = number, and store cx at [di]
get_number_0:
	call	skip_blanks
	call	get_digit		;is there really a number here?
	jc	get_number_3
	or	al,al			;Does the number begin with zero?
	jne	get_number_4		;no.
	mov	bp,8			;yes - they want octal.
get_number_4:

	xor	cx,cx			;get a hex number.
	xor	bx,bx
get_number_1:
	lodsb
	cmp	al,'x'			;did they really want hex?
	je	get_number_5		;yes.
	cmp	al,'X'			;did they really want hex?
	je	get_number_5		;yes.
	call	get_digit		;convert a character into an int.
	jc	get_number_2		;not a digit (neither hex nor dec).
	xor	ah,ah
	cmp	ax,bp			;larger than our base?
	jae	get_number_2		;yes.

	push	ax			;save the new digit.

	mov	ax,bp			;multiply the low word by ten.
	mul	cx
	mov	cx,ax			;keep the low word.
	push	dx			;save the high word for later.
	mov	ax,bp
	mul	bx
	mov	bx,ax			;we keep only the low word (which is our high word)
	pop	dx
	add	bx,ax			;add the high result from earlier.

	pop	ax			;get the new digit back.
	add	cx,ax			;add the new digit in.
	adc	bx,0
	jmp	get_number_1
get_number_5:
	mov	bp,16			;change the base to hex.
	jmp	get_number_1
get_number_2:
	dec	si
	mov	[di],cx			;store the parsed number.
	clc
	ret
get_number_3:
	stc
	ret


	public	skip_blanks
skip_blanks:
	lodsb				;skip blanks.
	cmp	al,' '
	je	skip_blanks
	cmp	al,HT
	je	skip_blanks
	dec	si
	ret


get_digit:
;enter with al = character
;return nc, al=digit, or cy if not a digit.
	cmp	al,'0'			;decimal digit?
	jb	get_digit_1		;no.
	cmp	al,'9'			;. .?
	ja	get_digit_2		;no.
	sub	al,'0'
	clc
	ret
get_digit_2:
	or	al,20h
	cmp	al,'a'			;hex digit?
	jb	get_digit_1
	cmp	al,'f'			;hex digit?
	ja	get_digit_1
	sub	al,'a'-10
	clc
	ret
get_digit_1:
	stc
	ret

print_number:
;enter with dx -> dollar terminated name of number, di ->dword.
;exit with the number printed and the cursor advanced to the next line.
	mov	ah,9			;print the name of the number.
	int	21h
	mov	al,'0'
	call	chrout
	mov	al,'x'
	call	chrout
	mov	ax,[di]			;print the number in hex.
	mov	dx,[di+2]
	call	hexout
	mov	al,' '
	call	chrout
	mov	al,'('
	call	chrout
	mov	ax,[di]			;print the number in decimal.
	mov	dx,[di+2]
	call	decout
	mov	al,')'
	call	chrout
	mov	al,CR
	call	chrout
	mov	al,LF
	call	chrout
	ret

	public	hexout
hexout:
	mov	cl,'0'			;prepare to eliminate leading zeroes.
	xchg	ax,dx			;just output 32 bits in hex.
	call	wordout			;output dx.
	xchg	ax,dx
	jmp	wordout			;output ax.

	public	decout
decout:
	mov	si,ax			;get the number where we want it.
	mov	di,dx

	xor	ax,ax			;start with all zeroes in al,bx,bp
	mov	bx,ax
	mov	bp,ax

	mov	cx,32			;32 bits in two 16 bit registers.
decout_1:
	shl	si,1
	rcl	di,1
	xchg	bp,ax
	call	addbit
	xchg	bp,ax
	xchg	bx,ax
	call	addbit
	xchg	bx,ax
	adc	al,al
	daa
	loop	decout_1

	mov	cl,'0'			;prepare to eliminate leading zeroes.
	call	byteout			;output the first two.
	mov	ax,bx			;output the next four
	call	wordout			;output the next four
	mov	ax,bp
wordout:
	push	ax
	mov	al,ah
	call	byteout
	pop	ax
byteout:
	mov	ah,al
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	call	digout
	mov	al,ah
digout:
	and	al,0fh
	add	al,90h	;binary digit to ascii hex digit.
	daa
	adc	al,40h
	daa
	cmp	al,cl			;leading zero?
	je	return
	mov	cl,-1			;no more leading zeros.
chrout:
	push	ax			;print the char in al.
	xchg	al,dl
	mov	ah,2
	int	21h
	xchg	al,dl
	pop	ax
return:
	ret


addbit:	adc	al,al
	daa
	xchg	al,ah
	adc	al,al
	daa
	xchg	al,ah
	ret


code	ends

	end	start
